/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core;

import com.aptana.debug.core.IEditorOpenAdapter;
import com.aptana.debug.core.LogLevelFilterManager;
import com.aptana.debug.core.internal.UniformResourceBreakpointChangeNotifier;
import com.aptana.debug.core.sourcelookup.RemoteSourceCacheManager;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.debug.core";
    private static DebugCorePlugin plugin;
    private UniformResourceBreakpointChangeNotifier breakpointHelper;
    private RemoteSourceCacheManager remoteSourceCacheManager;
    private LogLevelFilterManager logLevelFilterManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.breakpointHelper = new UniformResourceBreakpointChangeNotifier();
        this.remoteSourceCacheManager = new RemoteSourceCacheManager();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.remoteSourceCacheManager);
    }

    public void stop(BundleContext context) throws Exception {
        this.breakpointHelper.cleanup();
        this.logLevelFilterManager = null;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.remoteSourceCacheManager);
        super.stop(context);
        plugin = null;
    }

    public static DebugCorePlugin getDefault() {
        return plugin;
    }

    public RemoteSourceCacheManager getRemoteSourceCacheManager() {
        return this.remoteSourceCacheManager;
    }

    public static void openInEditor(Object sourceElement) {
        IEditorOpenAdapter adapter = (IEditorOpenAdapter)DebugCorePlugin.getDefault().getContributedAdapter(IEditorOpenAdapter.class);
        if (adapter != null) {
            adapter.openInEditor(sourceElement);
        }
    }

    public synchronized LogLevelFilterManager getLogLevelFilterManager() {
        if (this.logLevelFilterManager == null) {
            this.logLevelFilterManager = new LogLevelFilterManager();
        }
        return this.logLevelFilterManager;
    }

    private Object getContributedAdapter(Class<?> clazz) {
        Object adapter = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (manager.hasAdapter((Object)this, clazz.getName()) && (adapter = manager.getAdapter((Object)this, clazz.getName())) == null) {
            adapter = manager.loadAdapter((Object)this, clazz.getName());
        }
        return adapter;
    }
}

